Option Explicit
Const scriptName = "Double Outline"
Const scriptVer = "1.0.0"

' Revision History

' 1.0.0 - July 26, 2002 - MJM - Inital version.



' Script constants, questions, and error messages.
Const errNoSelection = "This script requires a text selection."




'Main

Dim errNum
errNum = 0

Dim CreatorApp
Set CreatorApp = WScript.CreateObject("Creator.Application")
'Set CreatorApp = GetObject(,"Creator.Application")

CreatorApp.Visible = True

Dim TextSel
If CreatorApp.Documents.Count = 0 Then
  Call MsgBox(errNoSelection, vbOkonly, scriptName)
  errNum = -1
End If

If errNum = 0 Then
  On Error Resume Next
  Set TextSel = CreatorApp.TextSelection
  errNum = Err.Number
  On Error GoTo 0
  
  If errNum <> 0 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
  Elseif TextSel.CharacterRuns.Count < 1 Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  Elseif TextSel.Start > TextSel.End Then
    Call MsgBox(errNoSelection, vbOkonly, scriptName)
    errNum = -1
  End If
End If

' Whew!  User Interface Section Done.
If errNum = 0 Then
  TextSel.Outline = True
  TextSel.Shadow = True

  TextSel.OutlineWeight = 8
  TextSel.HorizontalScale = 100
    
  TextSel.ShadowHorizontalOffset = 0
  TextSel.ShadowVerticalOffset = 0
  TextSel.ShadowSkew = 0
  TextSel.ShadowVerticalScale = 100
  TextSel.ShadowOutset = 8
End If




